/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console;

import filenet.sim.api.IVWSIMScenario;
import filenet.sim.api.IVWSIMSimulation;
import filenet.sim.api.VWSIMSession;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.VWSIMScenarioNode;
import filenet.sim.toolkit.console.VWSIMSimulationNode;
import filenet.sim.toolkit.console.images.VWSIMImageLoader;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMContents;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFolder;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Vector;
import javax.swing.ImageIcon;

public class VWSIMFolderNode
extends VWSIMBaseNode {
    protected static final ImageIcon nodeIconOpen16 = VWSIMImageLoader.createImageIcon("folder_o_16.gif");
    protected static final ImageIcon nodeIconOpenOverflow16 = VWSIMImageLoader.createImageIcon("folder_ovf_16.gif");
    protected static final ImageIcon nodeIconClosed16 = VWSIMImageLoader.createImageIcon("folder_c_16.gif");
    protected Vector m_simItems = new Vector();
    protected IVWIDMItem[] m_idmItemList = null;
    protected boolean m_folderPopulated = false;
    protected boolean m_bFolderOverflow = false;
    protected int m_itemCount = 0;
    protected int m_folderFilterLimit = 100;
    private static final int CONTENT_SCENARIO = 1;
    private static final int CONTENT_SIMULATION = 2;
    private static final int CONTENT_ALL = 3;
    private static final int CONTENT_SET_SIZE = 100;

    public VWSIMFolderNode(String name) {
        super(name, 16);
        this.setActionCommandString(VWSIMConsoleActionCommand.ACMD_FOLDER);
        this.setIcon16(nodeIconClosed16);
    }

    public VWSIMFolderNode(IVWIDMItem aIDMItem) {
        super(aIDMItem, 16, VWSIMConsoleActionCommand.ACMD_FOLDER);
        this.setIcon16(nodeIconClosed16);
    }

    public VWSIMFolderNode(IVWIDMItem aIDMItem, String name, VWSession vwSession, VWSIMSession simSession) {
        super(aIDMItem, 16, VWSIMConsoleActionCommand.ACMD_FOLDER);
        this.setIcon16(nodeIconClosed16);
        this.setName(name);
        this.setVWSession(vwSession);
        this.setSIMSession(simSession);
    }

    public Vector getScenarios() {
        this.releaseSimItems();
        this.getContent(1, false);
        return this.m_simItems;
    }

    public Vector getSimulations() {
        this.releaseSimItems();
        this.getContent(2, false);
        return this.m_simItems;
    }

    public Vector getSimContent(boolean bSort) {
        this.releaseSimItems();
        this.getContent(3, bSort);
        return this.m_simItems;
    }

    public int getFolderFilterLimit() {
        return this.m_folderFilterLimit;
    }

    public void setFolderFilterLimit(int sz) {
        this.m_folderFilterLimit = sz;
    }

    public void populateFolderFilterLimit(int sz) {
        this.m_folderFilterLimit = sz;
        for (int i = 0; i < this.getChildCount(); ++i) {
            VWSIMBaseNode aBaseNode = (VWSIMBaseNode)this.getChildAt(i);
            int nType = aBaseNode.getType();
            if (nType != 18 && nType != 16) continue;
            ((VWSIMFolderNode)aBaseNode).populateFolderFilterLimit(sz);
        }
    }

    private void getContent(int opt, boolean bSort) {
        try {
            if (this.m_idmItem != null) {
                IVWIDMFolder folder = (IVWIDMFolder)this.m_idmItem;
                Vector<String> optList = new Vector<String>();
                if (opt == 3) {
                    optList.add("ScenarioDefinition");
                    optList.add("Simulation");
                } else {
                    if ((opt & 2) > 0) {
                        optList.add("Simulation");
                    }
                    if ((opt & 1) > 0) {
                        optList.add("ScenarioDefinition");
                    }
                }
                int sz = optList.size();
                if (sz < 1) {
                    return;
                }
                Object[] classIds = new String[sz];
                optList.copyInto(classIds);
                String[] propertyList = new String[]{"Creator", "DateCreated", "DateLastModified", "ID", "DocumentTitle", "LastModifier", "PublishingEnabled", "ScenarioDefinitionDocId", "ScenarioDescription", "SimulationDescription", "SimulationGUID", "SimulationLifeSpanInHours", "SimulationStatus"};
                IVWIDMContents docs = folder.listContents((String[])classIds, this.m_folderFilterLimit, propertyList);
                if (docs == null) {
                    return;
                }
                while (docs.hasNext()) {
                    docs.getNextBatch();
                }
                Object[] batch = docs.list();
                this.m_itemCount = sz = batch.length;
                this.m_bFolderOverflow = docs.reachedFilterFolderMaxSize();
                if (bSort && sz > 0) {
                    VWQubbleSort.sort(batch);
                }
                for (int i = 0; i < sz; ++i) {
                    IVWIDMDocument aIVWIDMItem;
                    IVWIDMDocument aIVWIDMDocument = (IVWIDMDocument)batch[i];
                    if (aIVWIDMDocument.isSimulation()) {
                        if ((opt & 2) <= 0) continue;
                        IVWSIMSimulation aIVWSIMSimulation = this.m_simSession.createSimulationFromIdmDocument(aIVWIDMDocument);
                        aIVWIDMItem = aIVWSIMSimulation.getIDMDocument();
                        VWSIMSimulationNode aSimNode = new VWSIMSimulationNode((IVWIDMItem)aIVWIDMItem, aIVWSIMSimulation, this);
                        aSimNode.setSIMSession(this.m_simSession);
                        aSimNode.setVWSession(this.m_vwSession);
                        this.m_simItems.add(aSimNode);
                        continue;
                    }
                    if (!aIVWIDMDocument.isScenarioDefinition() || (opt & 1) <= 0) continue;
                    IVWSIMScenario aIVWSIMScenario = this.m_simSession.createScenarioFromIdmDocument(aIVWIDMDocument);
                    aIVWIDMItem = aIVWSIMScenario.getIDMDocument();
                    VWSIMScenarioNode aScnNode = new VWSIMScenarioNode((IVWIDMItem)aIVWIDMItem, aIVWSIMScenario, this);
                    aScnNode.setSIMSession(this.m_simSession);
                    aScnNode.setVWSession(this.m_vwSession);
                    this.m_simItems.add(aScnNode);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteAllChildren() {
        int i;
        if (this.m_idmItemList == null) {
            return;
        }
        for (i = 0; i < this.getChildCount(); ++i) {
            VWSIMBaseNode aBaseNode = (VWSIMBaseNode)this.getChildAt(i);
            if (aBaseNode.getType() != 16) continue;
            ((VWSIMFolderNode)aBaseNode).releaseResources();
        }
        this.removeAllChildren();
        for (i = 0; i < this.m_idmItemList.length; ++i) {
            this.m_idmItemList[i] = null;
        }
        this.m_idmItemList = null;
    }

    public void clearAll() {
        this.releaseResources();
    }

    public boolean populated() {
        return this.m_folderPopulated;
    }

    public void getSubFolders(boolean bRefresh) {
        try {
            if (bRefresh || !this.m_folderPopulated) {
                if (this.m_idmItem == null) {
                    return;
                }
                this.m_idmItem.refresh();
                this.deleteAllChildren();
                this.m_idmItemList = this.m_idmItem.list(true);
                if (this.m_idmItemList != null) {
                    for (int i = 0; i < this.m_idmItemList.length; ++i) {
                        VWSIMFolderNode aFolderNode = new VWSIMFolderNode(this.m_idmItemList[i]);
                        aFolderNode.setSIMSession(this.m_simSession);
                        aFolderNode.setVWSession(this.m_vwSession);
                        aFolderNode.setFolderFilterLimit(this.m_folderFilterLimit);
                        this.add(aFolderNode);
                    }
                }
                this.m_folderPopulated = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void refreshSubFolderContents() {
        int sz = this.getChildCount();
        for (int i = 0; i < sz; ++i) {
            VWSIMFolderNode subFolder = (VWSIMFolderNode)this.getChildAt(i);
            subFolder.getSubFolders(false);
        }
    }

    public void releaseSimItems() {
        if (this.m_simItems != null) {
            block4: for (int i = 0; i < this.m_simItems.size(); ++i) {
                VWSIMBaseNode aBaseNode = (VWSIMBaseNode)this.m_simItems.elementAt(i);
                switch (aBaseNode.getType()) {
                    case 33: {
                        ((VWSIMScenarioNode)aBaseNode).releaseResources();
                        continue block4;
                    }
                    case 34: {
                        ((VWSIMSimulationNode)aBaseNode).releaseResources();
                    }
                }
            }
            this.m_simItems.removeAllElements();
        }
    }

    public void releaseResources() {
        this.releaseSimItems();
        this.m_simItems = null;
        this.deleteAllChildren();
        super.releaseResources();
    }
}

